### Name: BootstrapBN
### Title: Bootstrap Bayesian networks
### Aliases: BootstrapBN
### Keywords: models

### ** Examples

## Not run: 
##D         library(BNArray)
##D         data(total.data)
##D         setwd("/home")  #for linux user
##D 
##D ##SHOULD call LLSimpute first
##D ori.compact<-LLSimpute(total.data$df.all,total.data$df.ori,total.data$n.changed)
##D 
##D ##Imputing the too bad missing values
##D ori.compact<-FinalImpute(ori.compact)
##D 
##D ##Prepare readily used complete database for constructing Bayesian network
##D bn.data<-PrepareCompData(ori.compact)
##D n.microarray<-dim(ori.compact)[2]
##D 
##D ##Do Bayesian network construction
##D ##select a subset genes to be modeled
##D selected.gene<-c(10:15)
##D bn.data<-bn.data[1:(n.microarray-1),selected.gene]
##D nw<-network(bn.data)
##D 
##D ##specify a prior network
##D nw.prior<-jointprior(nw,20)
##D nw<-getnetwork(learn(nw,bn.data,nw.prior))
##D 
##D ##perform greedy search
##D nw.search<-autosearchEx(nw,bn.data,nw.prior,removecycles=TRUE)
##D 
##D ##perturb initial network nw with random restarts to avoid local maximum
##D nw.heu<-heuristicEx(getnetwork(nw.search),bn.data,nw.prior,removecycles=TRUE,restart=2,degree=10,trylist=gettrylist(nw.search))
##D 
##D ##highest score network
##D nw.best<-getnetwork(nw.heu)
##D plot(nw.best,cexscale=3,unitscale=5)
##D 
##D ##Construct graph data matrix from network objects
##D g.matrix<-ConstGraphMatrix(total.data$n.changed,nw.heu,bn.data)
##D WriteBN(g.matrix)
##D 
##D ##Do Bootstraps
##D nboot<-3
##D boot.ret<-BootstrapBN(bn.data,nboot)
##D WriteBootBN(boot.ret)
## End(Not run)



