library(BNArray)
data(total.data)

##SHOULD call LLSimpute first
ori.compact<-LLSimpute(total.data$df.all,total.data$df.ori,total.data$n.changed)

##Imputing the too bad missing values
ori.compact<-FinalImpute(ori.compact)

##Prepare readily used complete database for constructing Bayesian network
bn.data<-PrepareCompData(ori.compact)
n.microarray<-dim(ori.compact)[2]

##Do Bayesian network construction
##select a subset genes to be modeled
selected.gene<-c(10:15)
bn.data<-bn.data[1:(n.microarray-1),selected.gene]
nw<-network(bn.data)

##specify a prior network
nw.prior<-jointprior(nw,20)
nw<-getnetwork(learn(nw,bn.data,nw.prior))

##perform greedy search
nw.search<-autosearchEx(nw,bn.data,nw.prior,removecycles=TRUE)

##perturb initial network nw with random restarts to avoid local maximum
nw.heu<-heuristicEx(getnetwork(nw.search),bn.data,nw.prior,removecycles=TRUE,restart=2,degree=10,trylist=gettrylist(nw.search))

##highest score network
nw.best<-getnetwork(nw.heu)
plot(nw.best,cexscale=3,unitscale=5)

##Construct graph data matrix from network objects
g.matrix<-ConstGraphMatrix(total.data$n.changed,nw.heu,bn.data)
WriteBN(g.matrix)

##Do Bootstraps
nboot<-3
boot.ret<-BootstrapBN(bn.data,nboot)
WriteBootBN(boot.ret)

#Calculate edge support and build a summary graph
g.width<-dim(g.matrix)[1]
sumgraph.matrix<-CalcEdgeSup(boot.ret$g.matrix.list.ret,nboot)
rownames(sumgraph.matrix)<-c(1:g.width)
colnames(sumgraph.matrix)<-c(1:g.width)

#display summary graph
DisplayGraph(sumgraph.matrix,names(bn.data[1,]))

#global variable "ret.dengraph.list" for HCS procedure calling with initialization
ret.dengraph.list<-list()
n.den.subgraph<-0
length(ret.dengraph.list)<-g.width

#global variable for HCS procedure calling with initialization
ii<-0	#for 1st-order
jj<-0	#for 2nd-order

#construct second order graph
ret.sedord.dengraph.list<-list()
coh.dengraph.list<-list()
coh.dengraph.final.list<-list()

xCODENSE(sumgraph.matrix,boot.ret)

#convert first-order graph to second-order graph
n.sedord.den.subgraph<-length(ret.sedord.dengraph.list)
length(coh.dengraph.list)<-n.den.subgraph	#global variable for HCS procedure calling with initialization
length(coh.dengraph.final.list)<-n.den.subgraph

