\name{BootstrapBN}
\alias{BootstrapBN}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Bootstrap Bayesian networks }
\description{
  Create a set of Bayesian networks by Efron's non-parametric bootstrap 
  evaluate network features.
}
\usage{
BootstrapBN(sam.tran, nboot, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sam.tran}{ an object of \code{data.frame} type with rows containing expression data in
	one microarray experiment and columns expression data of one gene across multiple experiments.
	The column names of \code{sam.tran} correspond to gene names/ORF }
  \item{nboot}{ folds to bootstrap }
  \item{\dots}{ passing parameters for later version usage }
}
\details{
  Microarray data are perturbed using non-parametric bootstrap with replacement to generate more data
 to construct several candidate Bayesian networks. This collection of Bayesian networks are further used
 for feature evaluation.
}
\value{
  A list with the following elements,
  \item{g.matrix.list.ret }{ A list each of which element is a adjacent matrix for each bootstraped
	Bayesian network}
  \item{tran.search.ret }{an object of \code{\link{autosearchEx}} result}
  \item{tran.search.ret }{a list of highest score networks candidate from \code{\link{heuristicEx}}}
  ...
}
\references{ 
  Further information about \bold{BNArray} can be found at:\cr
  \url{http://www.cls.zju.edu.cn/binfo/BNArray}. }
\author{ 
  Xiaohui Chen \email{cxh1984@interchange.ubc.ca}, \cr
  Kaida Ning \email{aprilnkd@hotmail.com}, \cr
  Ming Chen \email{mchen@zju.edu.cn}. }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{ ~~objects to See Also as \code{\link{~~fun~~}}, ~~~ }
\examples{
\dontrun{
	library(BNArray)
	data(total.data)
	setwd("/home")	#for linux user

##SHOULD call LLSimpute first
ori.compact<-LLSimpute(total.data$df.all,total.data$df.ori,total.data$n.changed)

##Imputing the too bad missing values
ori.compact<-FinalImpute(ori.compact)

##Prepare readily used complete database for constructing Bayesian network
bn.data<-PrepareCompData(ori.compact)
n.microarray<-dim(ori.compact)[2]

##Do Bayesian network construction
##select a subset genes to be modeled
selected.gene<-c(10:15)
bn.data<-bn.data[1:(n.microarray-1),selected.gene]
nw<-network(bn.data)

##specify a prior network
nw.prior<-jointprior(nw,20)
nw<-getnetwork(learn(nw,bn.data,nw.prior))

##perform greedy search
nw.search<-autosearchEx(nw,bn.data,nw.prior,removecycles=TRUE)

##perturb initial network nw with random restarts to avoid local maximum
nw.heu<-heuristicEx(getnetwork(nw.search),bn.data,nw.prior,removecycles=TRUE,restart=2,degree=10,trylist=gettrylist(nw.search))

##highest score network
nw.best<-getnetwork(nw.heu)
plot(nw.best,cexscale=3,unitscale=5)

##Construct graph data matrix from network objects
g.matrix<-ConstGraphMatrix(total.data$n.changed,nw.heu,bn.data)
WriteBN(g.matrix)

##Do Bootstraps
nboot<-3
boot.ret<-BootstrapBN(bn.data,nboot)
WriteBootBN(boot.ret)
}
}
\keyword{ models }
