\name{LLSimpute}
\alias{LLSimpute}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ local least squares imputation }
\description{
  Impute missing values using local least squares algorithm.
}
\usage{
LLSimpute(df.all, df.ori, n.changed)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{df.all}{ an object of \code{data.frame} which contains whole microarray data}
  \item{df.ori}{ an object of \code{data.frame} which contains  microarray data 
		of differentially expressed genes}
  \item{n.changed}{ the number of differentially expressed genes }
}
\details{
  LLSimpute employs local least squares algorithm to impute missing values in microarray data. 
Local least squares algorithm estimates missing values in a gene express vector according to 
the vector's most similar complete express vectors. The missing values are computed as the linear 
combination of the corresponding data in the nearest neighbor genes. Normally the coefficients could 
be computed but in rare cases when one gene misses too many values in total experiments, they take values
\code{NA}. Therefore, after calling \code{LLSimpute}, we have to \code{\link{FinalImpute}} function to 
ensure a complete database for constructing Bayesian networks.
}
\value{
  A data.frame object is returned with imputed data.
}
\references{ Hyunsoo Kim, Gene H. Golub and Haesum Park (2005) Missing value estimation for 
DNA microarray gene expression data: local least squares imputation, Bioinformatcs, 21, 187-198 }
\author{ Xiaohui Chen \email{cxh1984@interchange.ubc.ca}, \cr
  Kaida Ning \email{aprilnkd@hotmail.com}, \cr
  Ming Chen \email{mchen@zju.edu.cn}. }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{FinalImpute}} }
\examples{
\dontrun{
	library(BNArray)
	data(total.data)
	setwd("/home")

##SHOULD call LLSimpute first
	ori.compact<-LLSimpute(total.data$df.all,total.data$df.ori,total.data$n.changed)}
}
\keyword{ models }
