\name{EachGeneDataDistView}
\alias{EachGeneDataDistView}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Histgram of gene distribution }
\description{
  Plot a histgram of the expression levels of one or more genes distribution at a time 
across total experiments.
}
\usage{
EachGeneDataDistView(begin, end, expr.matrix)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{begin}{ the beginning gene number to plot}
  \item{end}{ the ending gene number to plot }
  \item{expr.matrix}{ a microarray expression matrix object with rows containing a gene expression 
levels across multi-experiment while columns denoting expression levels of all genes contained in 
one microarray slide. }
}
\details{
  View a gene expression level distribution within a total microarray experiment data set. Normally,
 we could perform further statistical test and find it is a normal distribution with \code{u=mean(vec),S=var(vec)},
 vec is the expression vector of a specified gene.
}
\value{
  No value returned.
}
\references{ 
	Further information about \bold{BNArray} can be found at:\cr
  \url{http://www.cls.zju.edu.cn/binfo/BNArray}. }
\author{ Xiaohui Chen \email{cxh1984@interchange.ubc.ca}, \cr
  Kaida Ning \email{aprilnkd@hotmail.com}, \cr
  Ming Chen \email{mchen@zju.edu.cn}. }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{EachMicroarrayDataDistView}} }
\examples{
	library(BNArray)
	data(total.data)
	attach(total.data)
	EachGeneDataDistView(5,5,df.ori)	#plot the 5th gene's expression level distribution
	EachGeneDataDistView(1,3,df.ori)	#plot the 1-3th gene's expression level distribution at one time
}
\keyword{ hplot }
