\name{EachMicroarrayDataDistView}
\alias{EachMicroarrayDataDistView}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Histgram of one microarray data distribution }
\description{
  Plot a histgram of the expression levels of one or more microarray data distribution at a time 
containing all gene in the microarray slides.
}
\usage{
EachMicroarrayDataDistView(begin, end, expr.matrix, n.changed)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{begin}{ the beginning microarray number to plot }
  \item{end}{ the ending microarray number to plot }
  \item{expr.matrix}{ a microarray expression matrix object with rows containing a gene expression 
levels across multi-experiment while columns denoting expression levels of all genes contained in 
one microarray slide. }
  \item{n.changed}{ the number of genes that differentially express }
}
\details{
  View a microarray expression level distribution containing all the genes in the slide. Normally,
 we could perform further statistical test and find it is a normal distribution with \code{u=mean(vec),S=var(vec)},
 vec is the expression vector of a specified microarray.
}
\value{
  No value returned.
}
\references{ 
	Further information about \bold{BNArray} can be found at:\cr
  \url{http://www.cls.zju.edu.cn/binfo/BNArray}. }
\author{ Xiaohui Chen \email{cxh1984@interchange.ubc.ca}, \cr
  Kaida Ning \email{aprilnkd@hotmail.com}, \cr
  Ming Chen \email{mchen@zju.edu.cn}. }
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{EachGeneDataDistView}} }
\examples{
	library(BNArray)
	data(total.data)
	attach(total.data)
	EachMicroarrayDataDistView(5,5,df.ori,n.changed)	#plot the 5th microarray expression level distribution
	EachMicroarrayDataDistView(1,3,df.ori,n.changed)	#plot the 1-3th microarray expression level distribution at one time
}
\keyword{ hplot }
