\name{autosearchEx}
\alias{autosearchEx}
\alias{heuristicEx}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Greedy search}

\description{
  From initial network, does local perturbations to increase network score.
}

\usage{
autosearchEx(initnw,data,prior=jointprior(network(data)),maxiter=50,
           trylist= vector("list",size(initnw)),trace=TRUE,
           timetrace=TRUE,showban=FALSE,removecycles=FALSE) 

heuristicEx(initnw,data,prior=jointprior(network(data)),
          maxiter=100,restart=10,degree=size(initnw),
          trylist= vector("list",size(initnw)),trace=TRUE,
          timetrace=TRUE,removecycles=FALSE)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{initnw}{an object of class \code{network}, from which the
    search is started. } 
  \item{data}{a data frame used for learning the network, see
    \code{network}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{jointprior}.} 
 \item{maxiter}{an integer, which gives the maximum number of steps in the
   search algorithm.} 
  \item{restart}{an integer, which gives the number of times to perturb
    \code{initnw} and rerun the 
    search.}
  \item{degree}{an integer, which gives the degree of perturbation, see
    \code{\perturb}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{maketrylist}.} 
  \item{trace}{a logical. If \code{TRUE}, plots the accepted networks
    during search.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
  \item{showban}{a logical passed to  the plot method for network
    objects. If
    \code{FALSE}, the banned arrows are not shown in the plots (if
    \code{trace} is \code{TRUE}).}
  \item{removecycles}{a logical. If \code{TRUE}, all networks explored in the
    search is returned, except for networks containing a cycle. If \code{FALSE}, all networks are returned, including
    cyclic networks.}
  \item{x}{an output object from a search.}
}

\details{
  In \code{autosearchEx}, a list of networks is in each step
  created with either one
  arrow added, one arrow deleted or one arrow turned (if a cycle is not
  generated). The network scores of all the proposal networks are
  calculated and the network with the highest score is chosen for the
  next step in the search. If no proposed network has a higher network
  score than the previous network, the search is terminated. The
  network with the highest network score is returned, along with a list
  containing all tried networks (depending on the value of \code{removecycles}).

  \code{heuristicEx} restarts by perturbing \code{initnw}
  \code{degree} times and calling 
  \code{autosearchEx} again. The number
  of restarts is given by the option \code{restart}.
}

\value{\code{autosearchEx} and \code{heuristicEx} returns a list with three
  elements, that may be accessed using \code{getnetwork},
  \code{gettable} and \code{gettrylist}. The elements are
  \item{nw}{an object of class \code{network}, which gives the
  network with the highest score.}
  \item{table}{a table with all tried
    networks. If removecycles is \code{FALSE}, the networks may contain
    cycles. The table contains two columns: \code{model} with a 
    string representation of the model and \code{score} with the
    corresponding log network score. The table can be translated to a
    \code{networkfamily} using \code{makenw}.}  
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{maketrylist}.}
}

\seealso{\code{perturb}
  }


\references{
  Further information about \bold{BNArray} can be found at:\cr
  \url{http://www.math.aau.dk/~dethlef/novo/deal} \cr
  \url{http://www.cls.zju.edu.cn/binfo/BNArray}. }
}

\author{
  Susanne Gammelgaard B鴗tcher \email{alma@math.aau.dk}, \cr
  Claus Dethlefsen \email{aas.claus.dethlefsen@nja.dk} \cr
  Xiaohui Chen \email{cxh1984@interchange.ubc.ca}, \cr
  Kaida Ning \email{aprilnkd@hotmail.com}, \cr
  Ming Chen \email{mchen@zju.edu.cn}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
\dontrun{
	library(BNArray)
	data(total.data)
	setwd("/home")	#for linux user

##SHOULD call LLSimpute first
ori.compact<-LLSimpute(total.data$df.all,total.data$df.ori,total.data$n.changed)

##Imputing the too bad missing values
ori.compact<-FinalImpute(ori.compact)

##Prepare readily used complete database for constructing Bayesian network
bn.data<-PrepareCompData(ori.compact)
n.microarray<-dim(ori.compact)[2]

##Do Bayesian network construction
##select a subset genes to be modeled
selected.gene<-c(10:15)
bn.data<-bn.data[1:(n.microarray-1),selected.gene]
nw<-network(bn.data)

##specify a prior network
nw.prior<-jointprior(nw,20)
nw<-getnetwork(learn(nw,bn.data,nw.prior))

##perform greedy search
nw.search<-autosearchEx(nw,bn.data,nw.prior,removecycles=TRUE)

##perturb initial network nw with random restarts to avoid local maximum
nw.heu<-heuristicEx(getnetwork(nw.search),bn.data,nw.prior,removecycles=TRUE,restart=2,degree=10,trylist=gettrylist(nw.search))

##highest score network
nw.best<-getnetwork(nw.heu)
plot(nw.best,cexscale=3,unitscale=5)
}
}

\keyword{models}
