"BootstrapBN" <-
function(sam.tran,nboot,...)

{

call<-match.call()

n<-length(sam.tran[,1])

bootsam<-matrix(sample(1:n,size=n*nboot,replace=TRUE),nrow=nboot,byrow=TRUE)



tran.h<-list()

length(tran.h)<-nboot

tran.parents.list<-list()

length(tran.parents.list)<-length(sam.tran[1,])

tran.parents.totallist<-list()

length(tran.parents.totallist)<-nboot

g.matrix.list<-list()

for(i in 1:nboot)

{

sam.temp<-sam.tran[bootsam[i,],]



tran.nw<-network(sam.temp)

tran.prior<-jointprior(tran.nw,20)

tran.nw<-getnetwork(learn(tran.nw,sam.temp,tran.prior))
X11()

tran.search<-autosearchEx(tran.nw,sam.temp,tran.prior,removecycles=TRUE)

tran.h[[i]]<-heuristicEx(getnetwork(tran.search),sam.temp,tran.prior,removecycles=TRUE,restart=2,degree=10,trylist=gettrylist(tran.search))
plot(getnetwork(tran.h[[i]]),cexscale=3,unitscale=5)



#Identify the parents of each nodes in the posterior network for further use,

#to construct network graph data structure



for(k in 1:length(sam.tran[1,]))

{

tran.parents.list[[k]]<-as.numeric(tran.h[[i]]$nw$nodes[[k]]$parents)

}

tran.parents.totallist[[i]]<-tran.parents.list





#store the Bayesian Network using graph data structure

g.width<-length(sam.tran[1,])

g.matrix<-matrix(0,ncol=g.width,nrow=g.width)

length(g.matrix.list)<-nboot


g.matrix.list[[i]]<-GraphStore(sam.temp,tran.parents.list)

WriteBN(g.matrix.list[[i]])

}

list(g.matrix.list.ret=g.matrix.list,tran.search.ret=tran.search,tran.h.ret=tran.h)

}

