"heuristicEx" <-
function (initnw, data, prior = jointprior(network(data)), maxiter = 100, 

    restart = 10, degree = size(initnw), trylist = vector("list", 

        size(initnw)), trace = TRUE, timetrace = TRUE, removecycles = FALSE) 

{

    if (timetrace) {

        t1 <- proc.time()

        cat("[Heuristic ")

    }

    if (timetrace) 

        s1 <- proc.time()[3]

    nwl <- autosearchEx(initnw, data, prior, maxiter, trylist, 

        trace = trace, timetrace = TRUE, removecycles = removecycles)

    nw <- nwl$nw

    trylist <- nwl$trylist

    table <- nwl$table

    if (timetrace) {

        s2 <- proc.time()[3]

        sauto <- s2 - s1

        spert <- 0

        suniq <- 0

    }

    if (restart > 0) {

        for (i in 1:restart) {

            if (timetrace) 

                s3 <- proc.time()[3]

            nw <- perturb(initnw, data, prior, degree, trylist = trylist, 

                timetrace = TRUE)

            trylist <- nw$trylist

            nw <- nw$nw

            ms <- modelstring(nw)

            if (timetrace) {

                s4 <- proc.time()[3]

                spert <- spert + s4 - s3

            }

            if (!is.na(match(ms, table[, 1]))) 

                next

            table <- rbind(table, cbind(ms, nw$score))

            if (trace) {

                plot(nw)

                title("New network")

            }

            if (timetrace) 

                s5 <- proc.time()[3]

            newnwl <- autosearchEx(nw, data, prior, maxiter, trylist = trylist, 

                trace = trace, timetrace = TRUE, removecycles = removecycles)

            trylist <- newnwl$trylist

            table <- rbind(table, newnwl$table)

            if (timetrace) {

                s6 <- proc.time()[3]

                sauto <- sauto + s6 - s5

            }

            if (timetrace) 

                s7 <- proc.time()[3]

            table <- table[!duplicated(table[, 1]), ]

            table <- table[sort.list(table[, 2]), ]

            if (timetrace) {

                s8 <- proc.time()[3]

                suniq <- suniq + s8 - s7

            }

        }

    }

    if (initnw$n < 15) 

        antal <- paste(numbermixed(initnw$nc, initnw$nd))

    else antal <- "many"

    cat("Tried", nrow(table), "out of approx.", antal, "networks\n")

    if (timetrace) {

        t2 <- proc.time()

        cat((t2 - t1)[1], "]\n")

        cat("Perturb:", spert, ",Autosearch:", sauto, ",Unique:", 

            suniq, "\n")

    }

    thebest <- as.network(table[1, ], initnw)

    thebest <- learn(thebest, data, prior)$nw

    list(nw = thebest, table = table, trylist = trylist)

}

