"autosearchEx" <-
function (initnw, data, prior = jointprior(network(data)), maxiter = 50, 

    trylist = vector("list", size(initnw)), trace = TRUE, timetrace = TRUE, 

    showban = FALSE, removecycles = FALSE) 

{

    if (timetrace) {

        t1 <- proc.time()

        cat("[Autosearch ")

        tadd <- 0

        trem <- 0

        ttur <- 0

        tsor <- 0

        tcho <- 0

    }

    nw <- initnw

    model <- modelstring(initnw)

    score <- initnw$score

    slut <- FALSE

    it <- 0

    hiscore <- initnw$score

    while (!slut & it < maxiter) {

        it <- it + 1

        if (timetrace) {

            s1 <- proc.time()[1]

        }

        thisnwl.add <- addarrow(nw, data, prior, trylist = trylist)

        trylist <- thisnwl.add$trylist

        thisnwl.add <- thisnwl.add$nw

        if (timetrace) {

            s2 <- proc.time()[1]

            tadd <- tadd + s2 - s1

        }

        thisnwl.rem <- removearrow(nw, data, prior, trylist = trylist)

        trylist <- thisnwl.rem$trylist

        thisnwl.rem <- thisnwl.rem$nw

        if (timetrace) {

            s3 <- proc.time()[1]

            trem <- trem + s3 - s2

        }

        thisnwl.tur <- turnarrow(nw, data, prior, trylist = trylist)

        trylist <- thisnwl.tur$trylist

        thisnwl.tur <- thisnwl.tur$nw

        if (timetrace) {

            s4 <- proc.time()[1]

            ttur <- ttur + s4 - s3

        }

        thisnwl <- c(thisnwl.add, thisnwl.rem, thisnwl.tur)

        class(thisnwl) <- "networkfamily"

        thisnwl <- nwfsort(thisnwl)

        if (timetrace) {

            s5 <- proc.time()[1]

            tsor <- tsor + s5 - s4

        }

        if (removecycles) {

            thisnwl <- thisnwl[!unlist(lapply(thisnwl, cycletest))]

            nwcand <- thisnwl[[1]]

        }

        else {

            kk <- 1

            while (TRUE) {

                nwcand <- thisnwl[[kk]]

                kk <- kk + 1

                if (!cycletest(nwcand)) 

                  break

                if (timetrace) 

                  cat(".")

            }

        }

        if (timetrace) {

            s6 <- proc.time()[1]

            tcho <- tcho + s6 - s5

        }

        model <- c(model, unlist(lapply(thisnwl, modelstring)))

        score <- c(score, unlist(lapply(thisnwl, function(x) x$score)))

        if (nwcand$score > hiscore) {

            hiscore <- nwcand$score

            nw <- nwcand

            if (trace) {

                plot(nw, showban = showban, cexscale=3, unitscale=5)

            }

            cat("(", it, ") ", hiscore, " ", modelstring(nw), 

                "\n", sep = "")

        }

        else {

            slut <- TRUE

        }

    }

    if (timetrace) {

        t2 <- proc.time()

        total <- (t2 - t1)[1]

        cat("Total", total, "add", tadd, "rem", trem, "turn", 

            ttur, "sort", tsor, "choose", tcho, "rest", total - 

                tadd - trem - ttur - tsor - tcho, "]\n")

    }

    table <- cbind(model, score)

    table <- table[sort.list(table[, 2]), ]

    list(nw = learn(nw, data, prior)$nw, table = table, trylist = trylist)

}

